#include <bits/stdc++.h>
using namespace std;

#pragma GCC optimize("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")

#define ll long long

using SortedList = set<ll>;

ll N, M, Q, P;
vector<ll> A;
vector<vector<ll>> adj;

vector<ll> time_of, low, bcc_id;
vector<bool> visited, art_poll;
ll timer = 0;
stack<pair<ll,ll>> edge_stack;
ll bcc_count = 0;

vector<set<ll>> bcc_components;
vector<ll> art_list;
map<ll,ll> art_index;
ll artCount;
ll BC_node_offset;
vector<vector<ll>> bc_adj;
vector<ll> v_to_BCnode;
vector<SortedList> bc_values;

vector<ll> parent, depth, subtree_size, heavy, head, pos;
vector<SortedList> base_array;
ll cur_pos;
ll bcN;

void dfs_bcc(ll u, ll parent) {
    visited[u] = true;
    timer++;
    time_of[u] = low[u] = timer;
    ll children = 0;

    for (ll w : adj[u]) {
        if (w == parent) continue;
        if (!visited[w]) {
            edge_stack.push({u, w});
            children++;
            dfs_bcc(w, u);
            low[u] = min(low[u], low[w]);

            if (parent == -1 && children > 1) {
                art_poll[u] = true;
            }
            if (parent != -1 && low[w] >= time_of[u]) {
                art_poll[u] = true;
            }

            if (low[w] >= time_of[u]) {
                bcc_count++;
                set<ll> comp_vertices;
                while (!edge_stack.empty()) {
                    auto [e_u, e_w] = edge_stack.top();
                    edge_stack.pop();
                    comp_vertices.insert(e_u);
                    comp_vertices.insert(e_w);
                    if (make_pair(e_u, e_w) == make_pair(u, w)) {
                        break;
                    }
                }
                bcc_components.push_back(comp_vertices);
            }
        }
        else if (time_of[w] < time_of[u]) {
            low[u] = min(low[u], time_of[w]);
            edge_stack.push({u, w});
        }
    }
}

void dfs_size(ll u, ll p = 0) {
    parent[u] = p;
    subtree_size[u] = 1;
    ll max_sub = 0;
    for (ll w : bc_adj[u]) {
        if (w == p) continue;
        depth[w] = depth[u] + 1;
        dfs_size(w, u);
        if (subtree_size[w] > max_sub) {
            max_sub = subtree_size[w];
            heavy[u] = w;
        }
        subtree_size[u] += subtree_size[w];
    }
}

void dfs_hld(ll u, ll h) {
    head[u] = h;
    cur_pos++;
    pos[u] = cur_pos;
    base_array[cur_pos] = bc_values[u];

    if (heavy[u] != 0) {
        dfs_hld(heavy[u], h);
    }
    for (ll w : bc_adj[u]) {
        if (w == parent[u] || w == heavy[u]) continue;
        dfs_hld(w, w);
    }
}

vector<pair<ll,ll>> hld_get_path(ll u, ll v) {
    vector<pair<ll,ll>> ret_segments;
    while (head[u] != head[v]) {
        if (depth[head[u]] > depth[head[v]]) {
            swap(u, v);
        }
        ll start_pos = pos[head[v]];
        ll end_pos = pos[v];
        ret_segments.push_back({start_pos, end_pos});
        v = parent[head[v]];
    }
    if (depth[u] > depth[v]) {
        swap(u, v);
    }
    ret_segments.push_back({pos[u], pos[v]});
    return ret_segments;
}

SortedList merge_sortedlists(const vector<pair<ll,ll>>& list_of_ranges) {
    SortedList final_set;
    for (auto [start_pos, end_pos] : list_of_ranges) {
        for (ll p = start_pos; p <= end_pos; p++) {
            for (ll val : base_array[p]) {
                final_set.insert(val);
            }
        }
    }
    return final_set;
}

ll find_median(const SortedList& sorted_set) {
    ll m = sorted_set.size();
    auto it = sorted_set.begin();
    advance(it, (m - 1) / 2);
    return *it;
}

int main() {
    ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0);

    cin >> N >> M >> Q >> P;
    
    A.resize(N + 1);
    for (ll i = 1; i <= N; i++) {
        cin >> A[i];
    }

    adj.resize(N + 1);
    for (ll i = 0; i < M; i++) {
        ll u, v;
        cin >> u >> v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    vector<pair<ll,ll>> queries_raw(Q);
    for (ll i = 0; i < Q; i++) {
        cin >> queries_raw[i].first >> queries_raw[i].second;
    }

    time_of.resize(N + 1);
    low.resize(N + 1);
    visited.resize(N + 1);
    bcc_id.resize(N + 1);
    art_poll.resize(N + 1);
    v_to_BCnode.resize(N + 1);

    dfs_bcc(1, -1);

    for (ll v = 1; v <= N; v++) {
        if (art_poll[v]) {
            art_list.push_back(v);
        }
    }
    
    for (ll i = 0; i < art_list.size(); i++) {
        art_index[art_list[i]] = i + 1;
    }
    artCount = art_list.size();
    BC_node_offset = artCount;

    bc_adj.resize(artCount + bcc_count + 1);
    bc_values.resize(artCount + bcc_count + 1);

    for (ll i = 0; i < bcc_count; i++) {
        ll BC_node_id = BC_node_offset + i + 1;
        for (ll v : bcc_components[i]) {
            if (art_poll[v]) {
                ll art_id = art_index[v];
                bc_adj[art_id].push_back(BC_node_id);
                bc_adj[BC_node_id].push_back(art_id);
            }
            else if (v_to_BCnode[v] == 0) {
                v_to_BCnode[v] = BC_node_id;
            }
        }
    }

    for (ll v : art_list) {
        v_to_BCnode[v] = art_index[v];
    }

    for (ll v = 1; v <= N; v++) {
        ll node_id = v_to_BCnode[v];
        bc_values[node_id].insert(A[v]);
    }

    bcN = artCount + bcc_count;
    parent.resize(bcN + 1);
    depth.resize(bcN + 1);
    subtree_size.resize(bcN + 1);
    heavy.resize(bcN + 1);
    head.resize(bcN + 1);
    pos.resize(bcN + 1);
    base_array.resize(bcN + 1);

    dfs_size(1);
    cur_pos = 0;
    dfs_hld(1, 1);

    ll ans_prev = 0;
    for (auto [a1, b1] : queries_raw) {
        ll a = ((a1 + ans_prev * P) - 1) % N + 1;
        ll b = ((b1 + ans_prev * P) - 1) % N + 1;

        if (a == b) {
            ans_prev = A[a];
            cout << ans_prev << '\n';
            continue;
        }

        ll Xa = v_to_BCnode[a];
        ll Xb = v_to_BCnode[b];

        auto segs = hld_get_path(Xa, Xb);

        auto big_set = merge_sortedlists(segs);

        ans_prev = find_median(big_set);
        cout << ans_prev << '\n';
    }

    return 0;
}